import sys
from PyQt5.QtWidgets import *
import requests
from bs4 import BeautifulSoup  # BeautifulSoup import
import HLHLF1
import HLHLF2
import Rmove
import H
import webbrowser
import load


class Ui_MainWindow2(QWidget):
    def __init__(self):
        super().__init__()
        self.blog = []
        self.setup()
        self.inf = {'정치': ('100','269') ,'경제': ('101','263'), '사회': ('102','257'), '문화': ('103','245'), '세계': ('104','322'),'과학': ('105','228'), 'IT': ('105','230')}
        self.sid1 = '100'
        self.sid2 = '269'
        self.sto = 0
        self.aa = []
        self.url=[]
        self.pre = []
        self.title=[]
        self.sel1 = ""
        self.sel2 = ""
        self.sel3 = ""
        self.dateP = 0
        self.ldata = load.news2()
        self.type = "정치"

    def setup(self):
        self.setWindowTitle('LineEdit1')
        self.resize(800, 800)

        self.line_edit = QLineEdit(self)
        self.line_edit.move(450, 20)
        self.line_edit.resize(100, 25)

        self.button = QPushButton(self)
        self.button.move(570, 25)
        self.button.setText('검색')
        self.button.clicked.connect(self.button_event2)

        centerGeometry = QDesktopWidget().availableGeometry().center()
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        self.rows = [
            ['', '', '','']
        ]
        headers = ['언론사', '제목','수정날짜','링크','평가']

        self.tableWidget = QTableWidget(self)
        self.tableWidget.resize(700, 600)
        self.tableWidget.move(50, 90)
        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(headers))
        self.tableWidget.setHorizontalHeaderLabels(headers)

        self.setTableWidgetData()
        self.tableWidget.horizontalHeader().setStretchLastSection(True)

        self.comboBox = QComboBox(self)
        self.comboBox.addItem('정치')
        self.comboBox.addItems(["경제", "사회","문화", "세계","과학", "IT"])
        self.comboBox.insertSeparator(6)
        self.comboBox.setCurrentIndex(0)
        self.comboBox.move(450, 57)
        self.comboBox.currentTextChanged.connect(self.comboBoxChanged)

        self.comboBoxChanged('')
        self.show()

    def comboBoxChanged(self, text):
        if text == '정치':
            self.sid1 = self.inf['정치'][0]
            self.sid2 = self.inf['정치'][1]
            print('정치')
            self.type = '정치'
        elif text == '경제':
            self.sid1 = self.inf['경제'][0]
            self.sid2 = self.inf['경제'][1]
            print('걍제')
            self.type = '경제'
        elif text == '사회':
            self.sid1 = self.inf['사회'][0]
            self.sid2 = self.inf['사회'][1]
            print('사회')
            self.type = '사회'
        elif text == '문화':
            self.sid1 = self.inf['문화'][0]
            self.sid2 = self.inf['문화'][1]
            print('문화')
            self.type = '문화'
        elif text == '세계':
            self.sid1 = self.inf['세계'][0]
            self.sid2 = self.inf['세계'][1]
            print('세계')
            self.type = '세계'
        elif text == '과학':
            self.sid1 = self.inf['과학'][0]
            self.sid2 = self.inf['과학'][1]
            print('과학')
            self.type = '과학'
        elif text == 'IT':
            self.sid1 = self.inf['IT'][0]
            self.sid2 = self.inf['IT'][1]
            print('IT')
            self.type = 'IT'


    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                item = QTableWidgetItem(self.rows[b][c])
                if c == 3:
                    urlbox = QPushButton(self)
                    self.tableWidget.setCellWidget(b, c, urlbox)
                    urlbox.clicked.connect(self.OpenLink)
                else:
                    self.tableWidget.setItem(b, c, item)

    def button_event2(self):
        self.url=[]
        self.aa=[]
        self.date = self.line_edit.text()
        self.dateP = self.date[0:4] + '.' + self.date[4:6] + '.' + self.date[6:8]
        print(self.dateP)

        response = requests.get(headers={'User-Agent': 'Mozilla/5.0'},url="https://news.naver.com/main/list.naver?mode=LS2D&sid2=%s&sid1=%s&mid=shm&date=%s&page=%s" % (self.sid2 , self.sid1 ,self.date,'1' ) )
        html = response.text
        soup = BeautifulSoup(html, 'html.parser')  # html.parser를 사용해서 soup에 넣겠다 td[class=content] li
        c = 0
        b=0
        for tag in soup.select('td[class=content] li'):

            self.sel1 = str(tag.select('span[class=writing]')[0])
            self.sel2 = str(tag.select('span[class=date]')[0])
            self.pre.append(Rmove.Rmove(self.sel1))
            if len(tag.find_all("a")) == 2:
                self.pre.append(tag.find("img")["alt"])
            else:
                self.pre.append(Rmove.Rmove(str(tag.find("a"))).strip())
            self.pre.append(Rmove.Rmove(self.sel2))
            self.pre.append(tag.find("a")["href"])
            self.url.append(tag.find("a")["href"])

            self.aa.append(self.pre)
            self.pre = []
            c = 0

        while (self.tableWidget.rowCount() > 0):
             self.tableWidget.removeRow(0)
        self.tableWidget.setRowCount(0)

        if H.news2(self.dateP , self.type) ==0:
            HLHLF1.news(self.aa,self.ldata,self.type)

        self.aa = (HLHLF2.news2(self.dateP))
        print(self.aa)
        self.rows = []
        self.blog = []
        a=0


        while a < 20:
            self.rows.append([self.aa[a][0],self.aa[a][1],self.aa[a][2],self.url[a] ,self.aa[a][4]])
            a=a+1
        self.tableWidget.setRowCount(len(self.rows))
        self.setTableWidgetData()

    def OpenLink(self):
        button = self.sender()
        tem = self.tableWidget.indexAt(button.pos())
        webbrowser.open(self.url[tem.row()])

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow2()

    sys.exit(app.exec_())
    # close event